<?php

use Illuminate\Support\Facades\Route;
use App\Services\SupplierDebtNoteService;
use App\Models\SupplierDebt;

// ...existing code...

// Custom Login Page
Route::get('/login', \App\Livewire\Auth\Login::class)
    ->name('login')
    ->middleware('guest');

// Logout Route (for Filament)
Route::post('/logout', function () {
    \Illuminate\Support\Facades\Auth::logout();
    request()->session()->invalidate();
    request()->session()->regenerateToken();
    return redirect('/login');
})->name('filament.admin.auth.logout')->middleware('auth');

// Download Supplier Debt Note
Route::get('/supplier-debt/{id}/note', function ($id) {
    $supplierDebt = SupplierDebt::findOrFail($id);
    return SupplierDebtNoteService::download($supplierDebt);
})->name('supplier-debt.note')->middleware(['auth']);

// Customer Display for POS (Real-time sync without authentication)
Route::get('/pos/customer-display', \App\Livewire\CustomerDisplay::class)->name('pos.customer-display');



